% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{psi_extend}
\alias{psi_extend}
\title{Simple Extension of a \code{dd} Model beyond the Search Radius}
\usage{
psi_extend(psi, fwin)
}
\arguments{
\item{psi}{\code{\link[=estpsi]{psiHat}} object}

\item{fwin}{fraction of carcasses assumed to lie within the search radius. If
\code{psi} includes \code{psiHat} for multiple carcass classes, \code{fwin}
should be either a vector with one value for each carcass class so that 
\code{length(psi) = length(fwin)} or a scalar (which assumes all carcasses, 
regardless of carcass class, have the same probability of landing outside the
search radius).}
}
\value{
\code{psiHat} object extended beyond the search radius
}
\description{
Extend a distance model beyond the search radius via multiplication by a fixed,
assumed constant rather than the default normalization used for extensible
models. \code{psi_extend} should not be used with \code{psiHat} objects that
were calculated with \code{extent = "full"}.
}
