% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_foodweb}
\alias{plot_foodweb}
\title{Plot foodweb}
\usage{
plot_foodweb(
  Q_ij,
  type_i,
  xtracer_i,
  ytracer_i = rep(1, nrow(Q_ij)),
  B_i = rep(1, nrow(Q_ij)),
  taxa_labels = letters[1:nrow(Q_ij)],
  xloc,
  yloc
)
}
\arguments{
\item{Q_ij}{Consumption of each prey i by predator j in units biomass.}

\item{type_i}{character vector indicating whether a taxon is "hetero", "auto", or
"detritus"}

\item{xtracer_i}{tracer to use when computing x-axis values}

\item{ytracer_i}{tracer to use when computing y-axis values}

\item{B_i}{biomass to use when weighting taxa in plot}

\item{taxa_labels}{character vector of labels to use for each taxon}

\item{xloc}{x-axis location (overrides calculation using \code{xtracer_i})}

\item{yloc}{y-axis location (overrides calculation using \code{ytracer_i})}
}
\value{
invisibly return \code{ggplot} object for foodweb
}
\description{
Plot consumption as a directed graph including all taxa (vertices)
and biomass consumed (arrows).  Taxa are located using tracers,
where by default the y-axis is trophic level.  #'
}
\details{
Trophic level \eqn{l_i} for each predator \eqn{i} is defined as:

\deqn{ \mathbf{l - 1 = l Q^*} }

where \eqn{\mathbf{Q*}} is the proportion consumption for each predator (column)
of different prey (rows).  We identify primary producers as any taxa with no
consumption (a column of 0s), and assign them as the first trophic level.
}
