% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectoryProjection.R
\name{trajectoryProjection}
\alias{trajectoryProjection}
\title{Trajectory projection}
\usage{
trajectoryProjection(
  d,
  target,
  trajectory,
  tol = 1e-06,
  add = TRUE,
  force = TRUE
)
}
\arguments{
\item{d}{A symmetric \code{\link{matrix}} or an object of class \code{\link{dist}} containing the distance values between pairs of ecological states (see details).}

\item{target}{An integer vector of the ecological states to be projected.}

\item{trajectory}{An integer vector of the ecological states conforming the trajectory onto which target states are to be projected.}

\item{tol}{Numerical tolerance value to determine that projection of a point lies within the trajectory.}

\item{add}{Flag to indicate that constant values should be added (local transformation) to correct triplets of distance values that do not fulfill the triangle inequality.}

\item{force}{Flag to indicate that when projection falls out of the reference trajectory for a given, the closest point in the trajectory will be used.}
}
\value{
A data frame with the following columns:
\itemize{
\item{\code{distanceToTrajectory}: Distances to the trajectory, i.e. rejection. If there is no orthogonal projection the distance corresponds to the minimum distance to the trajectory.}
\item{\code{segment}: Segment that includes the projected point or the closest state.}
\item{\code{relativeSegmentPosition}: Relative position of the projected point within the segment, i.e. values from 0 to 1 with 0 representing the start of the segment and 1 representing its end.}
\item{\code{relativeTrajectoryPosition}: Relative position of the projected point within the trajectory, i.e. values from 0 to 1 with 0 representing the start of the trajectory and 1 representing its end.}
}
}
\description{
Performs an projection of a set of target points onto a specified trajectory and returns the distance to the trajectory (i.e. rejection) and the relative position of the projection point within the trajectory.
}
\author{
Miquel De \enc{Cáceres}{Caceres}, CREAF
}
