% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{expr_apply}
\alias{expr_apply}
\title{Apply a function over expressions}
\usage{
expr_apply(
  x,
  f,
  depth = Inf,
  into = FALSE,
  order = c("pre", "post"),
  how = c("replace", "unlist", "unique"),
  env = parent.frame()
)
}
\arguments{
\item{x}{The R object; can be an \link[=elixir-expression]{expression}, a
\link[base:tilde]{formula}, or a list of arbitrary nestedness potentially
containing multiple expressions or formulas.}

\item{f}{Function to apply to all expressions within \code{x}; takes 1 to 3
arguments.}

\item{depth}{How many levels to recurse into lists; default is \code{Inf}.}

\item{into}{Whether to recurse into expressions. Can be \code{TRUE} to visit all
subexpressions, \code{FALSE} to not recurse, or \code{"leaves"} to recurse and only
apply \code{f} to terminal nodes of expressions (i.e. the symbols and syntactic
literals comprising the expressions).}

\item{order}{Whether a parent node is visited before ("pre") or after
("post") its children (the terminology comes from pre-order and post-order
depth-first search). This only has an effect if \code{into == TRUE}.}

\item{how}{How to structure the result.}

\item{env}{Environment for injections in \code{x} (see
\link[=elixir-expression]{expression}).}
}
\value{
If \code{how = "replace"} (the default), the original object \code{x} with \code{f}
applied to expressions within it. If \code{how = "unlist"}, the same but with
\code{\link[=unlist]{unlist()}} applied to it. If \code{how = "unique"}, first \code{\link[=unlist]{unlist()}} then
\code{\link[=unique]{unique()}} are applied.
}
\description{
Recursively apply a function over an \link[=elixir-expression]{expression}, or any
expression elements of a list, and optionally the subexpressions within any
expressions.
}
\details{
The function \code{f} can take one to three arguments. The first argument is the
expression itself for \code{f} to apply to, and \code{f} should return some kind of
replacement for, or modified version of, this argument.

The second argument is a list with information about the name of the
expression in the list \code{x} and of its parents. Specifically, the first
element of the list is the name of the expression, the second element of the
list is the name of the "parent" of the expression, and so on. If any
elements in this chain are unnamed, an integer is provided as the name. If
the expression is within another expression (which only happens with
\code{into = TRUE}), this is signalled as a \code{NULL} at the top of the list, one
for each level of recursion into the expression.

The third argument is an integer vector, the index into \code{x} where
\code{f} is currently operating. This is suitable for use with \code{\link[=expr_sub]{expr_sub()}}.
}
\examples{
expr_apply(list(quote(a + b), quote(c)), function(x) all.vars(x), how = "unlist")
}
