% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.glm.R
\name{elo.glm}
\alias{elo.glm}
\title{Compute a (usually logistic) regression model for a series of matches.}
\usage{
elo.glm(
  formula,
  data,
  family = "binomial",
  weights,
  na.action,
  subset,
  ...,
  running = FALSE,
  skip = 0
)
}
\arguments{
\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{family}{Argument passed to \code{\link[stats]{glm}}.}

\item{weights}{Argument passed to \code{\link[stats]{glm}}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{...}{Argument passed to \code{\link[stats]{glm}}.}

\item{running}{Logical, denoting whether to calculate "running" projected probabilities. If true, a model is fit for
group 1 on its own to predict group 2, then groups 1 and 2 to predict 3, then groups 1 through 3 to predict 4, etc.
Groups are determined in \code{formula}. Omitting a group term re-runs a glm model to predict each
observation (a potentially time-consuming operation!)}

\item{skip}{Integer, denoting how many groups to skip before fitting the running models. This is helpful if
groups are small, where glm would have trouble converging for the first few groups. The predicted values are then
set to 0.5 for the skipped groups.}
}
\value{
An object of class \code{c("elo.glm", "glm")}. If \code{running==TRUE}, the class \code{"elo.glm.running"}
  is prepended.
}
\description{
Compute a (usually logistic) regression model for a series of matches.
}
\details{
The formula syntax is the same as other \code{elo} functions. A data.frame
  of indicator variables is built, where an entry is 1 if a team is home, 0 if
  a team didn't play, and -1 if a team is a visitor. Anything passed to \code{\link{adjust}()} in
  \code{formula} is also put in the data.frame. A \code{\link{glm}} model is then
  run to predict wins or margin of victory.

  With this setup, the intercept represents the home-field advantage. Neutral fields can be indicated
  using the \code{\link{neutral}()} function, which sets the intercept to 0.

  Note that any weights specified in \code{players()} will be ignored.

  This is essentially the Bradley-Terry model.
}
\examples{
data(tournament)
elo.glm(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = tournament,
  subset = points.Home != points.Visitor)
elo.glm(mov(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = tournament,
  family = "gaussian")
}
\references{
https://en.wikipedia.org/wiki/Bradley%E2%80%93Terry_model
}
\seealso{
\code{\link[stats]{glm}}, \code{\link{summary.elo.glm}}, \code{\link{score}},
  \code{\link{mov}}, \code{\link{elo.model.frame}}
}
