% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.prob.R
\name{elo.prob}
\alias{elo.prob}
\alias{elo.prob.default}
\alias{elo.prob.formula}
\alias{elo.prob.elo.multiteam.matrix}
\title{Elo probability}
\usage{
elo.prob(elo.A, ...)

\method{elo.prob}{default}(elo.A, elo.B, ..., elos = NULL, adjust.A = 0, adjust.B = 0)

\method{elo.prob}{formula}(formula, data, na.action, subset, ..., elos = NULL)

\method{elo.prob}{elo.multiteam.matrix}(elo.A, ..., elos = NULL)
}
\arguments{
\item{elo.A, elo.B}{Numeric vectors of elo scores, or else vectors of teams.}

\item{...}{Other arguments (not in use at this time).}

\item{elos}{An optional named vector containing Elo ratings for all teams in \code{formula}
or \code{elo.A} and \code{elo.B}.}

\item{adjust.A, adjust.B}{Numeric vectors to adjust \code{elo.A} and \code{elo.B} by.}

\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}
}
\value{
A vector of Elo probabilities.
}
\description{
Calculate the probability that team A beats team B. This is vectorized.
}
\details{
Note that \code{formula} can be missing the \code{wins.A} component. If
  present, it's ignored by \code{\link{elo.model.frame}}.
}
\examples{
elo.prob(1500, 1500)
elo.prob(c(1500, 1500), c(1500, 1600))

dat <- data.frame(wins.A = c(1, 0), elo.A = c(1500, 1500),
                  elo.B = c(1500, 1600), k = c(20, 20))
elo.prob(~ elo.A + elo.B, data = dat)

## Also works to include the wins and k:
elo.prob(wins.A ~ elo.A + elo.B + k(k), data = dat)

## Also allows teams
elo.prob(c("A", "B"), c("C", "C"), elos = c(A = 1500, B = 1600, C = 1500))

}
\seealso{
\code{\link{elo.update}}, \code{\link{elo.calc}},
  \code{elo.model.frame}
}
