% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carpetplot.R
\name{carpetplot}
\alias{carpetplot}
\title{Carpetplot}
\usage{
carpetplot(
  x,
  qcut = 0.1,
  fname = NULL,
  center = TRUE,
  scale = FALSE,
  colors = "gray255",
  sortSub = TRUE,
  ...
)
}
\arguments{
\item{x}{The \eqn{T \times V} numeric data matrix, or a \code{"xifti"} object.
In the plot, the \eqn{T} index will increase from left to right, and the
\eqn{V} will increase from top to bottom.}

\item{qcut}{Sets blackpoint at the \code{qcut} quantile, and the
whitepoint at the \code{1-qcut} quantile. Default: \code{.1}. This is
equivalent to setting the color range between the 10\% and 90\% quantiles.
The quantiles are computed across the entire data matrix after any
centering or scaling.

Must be between 0 and .49. If \code{0} or \code{NULL} (default), do not
clamp the data values.}

\item{fname}{A \code{.pdf} (highly recommended) or \code{.png} file path
to write the carpetplot to. If \code{NULL} (default), return the plot directly
instead of writing a file.}

\item{center, scale}{Center and scale the data? If \code{x} is fMRI data
which has not otherwise been centered or scaled, it is recommended to center
but not scale it (default).}

\item{colors}{\code{"gray255"} (default) will use a grayscale color ramp
from black to white. Otherwise, this should be a character vector of
color names to use.

Colors will be assigned from the lowest to the highest data value, after
any clamping of the data values by \code{qcut}.}

\item{sortSub}{If \code{x} is a \code{"xifti"} object with subcortical data,
should the voxels be sorted by structure alphabetically? Default: \code{TRUE}.}

\item{...}{Additional arguments to \code{pdf} or \code{png}, such as width
and height.}
}
\value{
The image or \code{NULL, invisibly} if a file was written.
}
\description{
Plot a matrix with \code{graphics::image}. For fMRI data, this is the
"carpetplot" or grayplot coined by (Power, 2017). The \code{graphics} and
\code{grDevices} packages are required.
}
\section{References}{

\itemize{
\item{Power, J. D. A simple but useful way to assess fMRI scan qualities. NeuroImage 154, 150-158 (2017).}
}
}

