% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRR_BuildBackend.R
\name{build_backend}
\alias{build_backend}
\title{A function to build the environment for fastrerandomize. Builds a conda environment in which 'JAX' and 'np' are installed. Users can also create a conda environment where 'JAX' and 'np' are installed themselves.}
\usage{
build_backend(conda_env = "fastrerandomize_env", conda = "auto")
}
\arguments{
\item{conda_env}{(default = \code{"fastrerandomize_env"}) Name of the conda environment in which to place the backends.}

\item{conda}{(default = \code{auto}) The path to a conda executable. Using \code{"auto"} allows reticulate to attempt to automatically find an appropriate conda binary.}
}
\value{
Invisibly returns NULL; this function is used for its side effects
of creating and configuring a conda environment for \code{fastrerandomize}.
This function requires an Internet connection.
You can find out a list of conda Python paths via: \code{Sys.which("python")}
}
\description{
A function to build the environment for fastrerandomize. Builds a conda environment in which 'JAX' and 'np' are installed. Users can also create a conda environment where 'JAX' and 'np' are installed themselves.
}
\examples{
\dontrun{
# Create a conda environment named "fastrerandomize_env"
# and install the required Python packages (jax, numpy, etc.)
build_backend(conda_env = "fastrerandomize_env", conda = "auto")

# If you want to specify a particular conda path:
# build_backend(conda_env = "fastrerandomize_env", conda = "/usr/local/bin/conda")
}

}
