% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_flood.R
\name{range_flood}
\alias{range_flood}
\alias{range_clear}
\title{Flood or clear a range of cells}
\usage{
range_flood(ss, sheet = NULL, range = NULL, cell = NULL, reformat = TRUE)

range_clear(ss, sheet = NULL, range = NULL, reformat = TRUE)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet:
\itemize{
\item its file id as a string or \code{\link[googledrive:drive_id]{drive_id}}
\item a URL from which we can recover the id
\item a one-row \code{\link[googledrive:dribble]{dribble}}, which is how googledrive
represents Drive files
\item an instance of \code{googlesheets4_spreadsheet}, which is what \code{\link[=gs4_get]{gs4_get()}}
returns
}

Processed through \code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{Sheet to write into, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number.}

\item{range}{A cell range to read from. If \code{NULL}, all non-empty cells are
read. Otherwise specify \code{range} as described in \href{https://developers.google.com/sheets/api/guides/concepts#a1_notation}{Sheets A1 notation}
or using the helpers documented in \link{cell-specification}. Sheets uses
fairly standard spreadsheet range notation, although a bit different from
Excel. Examples of valid ranges: \code{"Sheet1!A1:B2"}, \code{"Sheet1!A:A"},
\code{"Sheet1!1:2"}, \code{"Sheet1!A5:A"}, \code{"A1:B2"}, \code{"Sheet1"}. Interpreted
strictly, even if the range forces the inclusion of leading, trailing, or
embedded empty rows or columns. Takes precedence over \code{skip}, \code{n_max} and
\code{sheet}. Note \code{range} can be a named range, like \code{"sales_data"}, without
any cell reference.}

\item{cell}{The value to fill the cells in the \code{range} with. If unspecified,
the default of \code{NULL} results in clearing the existing value.}

\item{reformat}{Logical, indicates whether to reformat the affected cells.
Currently googlesheets4 provides no real support for formatting, so
\code{reformat = TRUE} effectively means that edited cells become unformatted.}
}
\value{
The input \code{ss}, as an instance of \code{\link{sheets_id}}
}
\description{
\code{range_flood()} "floods" a range of cells with the same content.
\code{range_clear()} is a wrapper that handles the common special case of
clearing the cell value. Both functions, by default, also clear the format,
but this can be specified via \code{reformat}.
}
\examples{
\dontshow{if (gs4_has_token()) withAutoprint(\{ # examplesIf}
# create a data frame to use as initial data
df <- gs4_fodder(10)

# create Sheet
ss <- gs4_create("range-flood-demo", sheets = list(df))

# default behavior (`cell = NULL`): clear value and format
range_flood(ss, range = "A1:B3")

# clear value but preserve format
range_flood(ss, range = "C1:D3", reformat = FALSE)

# send new value
range_flood(ss, range = "4:5", cell = ";-)")

# send formatting
# WARNING: use these unexported, internal functions at your own risk!
# This not (yet) officially supported, but it's possible.
blue_background <- googlesheets4:::CellData(
  userEnteredFormat = googlesheets4:::new(
    "CellFormat",
    backgroundColor = googlesheets4:::new(
      "Color",
      red = 159 / 255, green = 183 / 255, blue = 196 / 255
    )
  )
)
range_flood(ss, range = "I:J", cell = blue_background)

# range_clear() is a shortcut where `cell = NULL` always
range_clear(ss, range = "9:9")
range_clear(ss, range = "10:10", reformat = FALSE)

# clean up
gs4_find("range-flood-demo") \%>\%
  googledrive::drive_trash()
\dontshow{\}) # examplesIf}
}
\seealso{
Makes a \code{RepeatCellRequest}:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#repeatcellrequest}
}

Other write functions: 
\code{\link{gs4_create}()},
\code{\link{gs4_formula}()},
\code{\link{range_delete}()},
\code{\link{range_write}()},
\code{\link{sheet_append}()},
\code{\link{sheet_write}()}
}
\concept{write functions}
