% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridify-methods.R
\name{print,gridifyClass-method}
\alias{print,gridifyClass-method}
\title{Print method for gridifyClass}
\usage{
\S4method{print}{gridifyClass}(x, ...)
}
\arguments{
\item{x}{A gridifyClass object.}

\item{...}{Additional arguments. Not yet in use.}
}
\value{
Invisibly a grid call used to draw the object.
}
\description{
Method for printing a gridifyClass object.
Prevents the \code{show} method from being triggered.
}
\examples{
# (to use |> version 4.1.0 of R is required, for lower versions we recommend \%>\% from magrittr)
library(magrittr)

g <- gridify(
  object = ggplot2::ggplot(data = mtcars, ggplot2::aes(x = mpg, y = wt)) +
    ggplot2::geom_line(),
  layout = simple_layout()
) \%>\%
  set_cell("title", "TITLE")

print(g)

# grid call is returned when printed to a variable
gg <- print(g)
# unevaluated grid code
gg
# evaluate the code
grid::grid.draw(eval(gg, envir = attr(gg, "env")))
# or
OBJECT <- attr(gg, "env")[["OBJECT"]]
grid::grid.draw(eval(gg))
}
\seealso{
\code{\link[=gridify]{gridify()}}, \code{\link[=set_cell]{set_cell()}}
}
