% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvrnorm2.R
\name{mvrnorm2}
\alias{mvrnorm2}
\title{Expand Types of \code{Sigma} in \link[MASS]{mvrnorm}}
\usage{
mvrnorm2(n, mu, sd, Sigma = diag(x = sd^2, nrow = d, ncol = d), ...)
}
\arguments{
\item{n}{\link[base]{integer} scalar, sample size}

\item{mu}{\link[base]{numeric} scalar or \link[base]{vector},
multivariate means \eqn{\mathbf{\mu}}'s}

\item{sd}{\link[base]{numeric} scalar or a \link[base]{vector}, standard deviation(s)}

\item{Sigma}{\link[base]{numeric} \link[stats]{var}iance-\link[stats]{cov}ariance \link[base]{matrix}, see function \link[MASS]{mvrnorm}}

\item{...}{additional parameter of function \link[MASS]{mvrnorm}}
}
\value{
Function \code{\link[=mvrnorm2]{mvrnorm2()}} returns a \link[base]{double} \link[base]{matrix}.
}
\description{
To accommodate more types of \code{Sigma} in function \link[MASS]{mvrnorm}.
}
\details{
Argument of parameter \code{sd} could be

\describe{

\item{scalar}{\code{sd} is recycled to the \link[base]{length} of \code{mu}}

\item{\link[base]{vector}}{check that \link[base]{length} of \code{sd} and \code{mu} must be the same}

}

Then a \link[base]{diag}onal \link[base]{matrix} with \link[base]{vector} \code{sd^2} on the diagonal elements
is used as the \link[stats]{var}iance-\link[stats]{cov}ariance
\link[base]{matrix} \eqn{\Sigma}
}
\note{
Workhorse function \link[MASS]{mvrnorm} from package \CRANpkg{MASS} is faster than \code{?mvtnorm::rmvnorm}.
}
\keyword{internal}
