% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_utils.R
\name{get_widest_bbox}
\alias{get_widest_bbox}
\title{Compute the union bounding box from multiple shapes}
\usage{
get_widest_bbox(shapes)
}
\arguments{
\item{shapes}{A list of sf objects.}
}
\value{
A named numeric vector with elements: \code{ymin}, \code{xmin}, \code{xmax}, \code{ymax}
representing the union of all input bounding boxes.
}
\description{
Calculates the overall bounding box that encompasses all provided spatial shapes.
}
\examples{
library(sf)

# Load sample data
nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

# Get the bounding box of the entire dataset
bbox <- get_widest_bbox(list(nc))
bbox

}
