% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fup_uc.R
\name{plot_fup_uc}
\alias{plot_fup_uc}
\title{Plot Mass Spectrometry Responses for Fraction Unbound in Plasma Data from
Ultracentrifugation (UC)}
\usage{
plot_fup_uc(
  level2,
  dtxsid,
  compare = "type",
  good.col = "Verified",
  color.palette = "viridis"
)
}
\arguments{
\item{level2}{(Data Frame) A data.frame containing level-2 data for fraction
unbound in plasma (Fup) measured by ultracentrifugation (UC).}

\item{dtxsid}{(Character) EPA's DSSTox Structure ID for the chemical to be plotted.}

\item{compare}{(Character) A string indicating the plot is for 
comparing the responses across sample types ("type") or across calibrations ("cal").
(Defaults to "type".)}

\item{good.col}{(Character) Column name containg verification information,
data rows valid for plotting are indicated with a "Y". (Defaults to "Verified".)}

\item{color.palette}{(Character) A character string indicating which 
\code{viridis} R package color map option to use. (Defaults to "viridis".)}
}
\value{
\item{ggplot2}{A figure of mass spectrometry responses for
various sample types.}
}
\description{
This function generates a scatter plot of mass spectrometry (MS) responses 
for one chemical collected from measurement of fraction unbound in plasma (Fup)
using ultracentrifugation (UC). The scatter plot displays the MS 
responses (y-axis) by sample types (x-axis). Responses from different
measurements/calibrations are labeled with different shapes and colors.
}
\details{
This function requires "level-2" data for plotting. Level-2 data is level-1,
data formatted with the \code{\link{format_fup_uc}} function, and curated
with a verification column. "Y" in the verification column indicates the
data row is valid for plotting.
}
\examples{
## Load example level-2 data 
level2 <- invitroTKstats::fup_uc_L2
plot_fup_uc(level2, dtxsid = "DTXSID0059829")

}
\author{
John Wambaugh
}
