% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{ironseed_stream}
\alias{ironseed_stream}
\alias{create_seedseq}
\title{Ironseed output seed sequences}
\usage{
ironseed_stream(..., methods = c("dots", "args", "env", "auto", "null"))

create_seedseq(fe, n)
}
\arguments{
\item{...}{objects}

\item{methods}{a character vector.}

\item{fe}{an ironseed}

\item{n}{a scalar integer specifying the number of seeds to generate}
}
\value{
an integer vector containing 32-bit output seeds. If \code{n} is missing,
\code{ironseed_stream()} returns the underlying ironseed.
}
\description{
Output sequences of 32-bit seeds are generated from an ironseed using
multilinear hashes. The coefficients for these hashes are generated by a
different Weyl sequence from the input hashes. A hash finalizer is also used
to mix bits and improve observed randomness.
\itemize{
\item \code{create_seedseq()} uses an ironseed to generate a sequence of 32-bit seeds.
\item \code{ironseed_stream()} returns a function that can be used to generate
a seed sequence iteratively.
}
}
\examples{
# Generate 20 seeds from an ironseed
fe <- ironseed("Experiment", 20251031, 1, set_seed = FALSE)
create_seedseq(fe, 20)

# Create a function that can be called multiple times to produce seeds
get_seeds <- ironseed_stream("Experiment", 20251031, 1)

# generate 10 seeds
get_seeds(10)

# generate 10 more seeds
get_seeds(10)

# output the ironseed used for the stream
get_seeds()

}
\seealso{
\link{ironseed}
}
