% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{plot_pca_surface}
\alias{plot_pca_surface}
\title{Visualization of the effect predictors in nonlinear interactions with 
principled components.}
\usage{
plot_pca_surface(
  x,
  pca.term = NULL,
  weights = NULL,
  view = NULL,
  cond = list(),
  partial = FALSE,
  select = NULL,
  se = -1,
  n.grid = 30,
  too.far = 0,
  rm.ranef = NULL,
  col = NA,
  color = "topo",
  contour.col = NULL,
  nCol = 50,
  plotCI = FALSE,
  add.color.legend = TRUE,
  plot.type = "contour",
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  print.summary = getOption("itsadug_print"),
  transform = NULL,
  transform.view = NULL,
  hide.label = FALSE,
  dec = NULL,
  ...
)
}
\arguments{
\item{x}{A gam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}.}

\item{pca.term}{Text string, name of model predictor that represents a 
principle component.}

\item{weights}{Named list with the predictors that are combined in the PC 
and their weights. See examples.}

\item{view}{A two-value vector containing the names of the two terms to 
plot. The two terms should be part of the PC. Note that 
variables coerced to factors in the model formula won't work as view 
variables.}

\item{cond}{A named list of the values to use for the other predictor 
terms (not in view). Used for choosing between smooths that share the 
same view predictors.}

\item{partial}{Logical value: whether or not to plot the partial effect 
(TRUE) or the summed effect (FALSE, default).}

\item{select}{Numeric value, model term. In case \code{partial=TRUE} a 
model term needs to be selected.}

\item{se}{If less than or equal to zero then only the predicted surface 
is plotted, but if greater than zero, then 3 surfaces are plotted, one at 
the predicted values minus se standard errors, one at the predicted 
values and one at the predicted values plus se standard errors.}

\item{n.grid}{The number of grid nodes in each direction used for 
calculating the plotted surface.}

\item{too.far}{Plot grid nodes that are too far from the points defined by 
the variables given in view can be excluded from the plot. too.far 
determines what is too far. The grid is scaled into the unit square along 
with the view variables and then grid nodes more than too.far from the 
predictor variables are excluded.}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is TRUE.}

\item{col}{The colors for the facets of the plot.}

\item{color}{The color scheme to use for plots. One of 'topo', 'heat', 
'cm', 'terrain', 'gray' or 'bw'.}

\item{contour.col}{sets the color of contours when using plot.}

\item{nCol}{The number of colors to use in color schemes.}

\item{plotCI}{Logical: whether or not to plot the confidence intervals. 
The value of \code{se} determines the size of the CI.}

\item{add.color.legend}{Logical: whether or not to add a color legend. 
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link[plotfunctions]{gradientLegend}} to add a legend manually at any position.}

\item{plot.type}{one of 'contour' or 'persp' (default is 'contour').}

\item{xlim}{A two item array giving the lower and upper limits for the x-
axis scale. NULL to choose automatically.}

\item{ylim}{A two item array giving the lower and upper limits for the y-
axis scale. NULL to choose automatically.}

\item{zlim}{A two item array giving the lower and upper limits for the z-
axis scale. NULL to choose automatically.}

\item{print.summary}{Logical: whether or not to print a summary.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{transform}{Function for transforming the fitted values. 
Default is NULL.}

\item{transform.view}{List with two functions for transforming 
the values on the x- and y-axis respectively. If one of the axes 
need to be transformed, set the other to NULL (no transformation).
See examples below.}

\item{hide.label}{Logical: whether or not to hide the label 
(i.e., 'fitted values'). Default is FALSE.}

\item{dec}{Numeric: number of decimals for rounding the color legend. 
When NULL, no rounding (default). If -1, automatically determined.  
Note: if value = -1, rounding will be applied also when 
\code{zlim} is provided.}

\item{...}{other options to pass on to persp, image or contour. In 
particular ticktype='detailed' will add proper axes labeling to the plots.}
}
\description{
Produces perspective or contour plot views of gam model 
predictions of the additive effects interactions.
The code is based on the script for \code{\link[mgcv]{vis.gam}}, 
but allows to cancel random effects.
}
\seealso{
\code{\link{fvisgam}}, \code{\link{pvisgam}}

Other Functions for PCA interpretation: 
\code{\link{get_pca_predictions}()}
}
\author{
Jacolien van Rij
data(simdat)
# add hypothetical correlated term:
simdat$predictor <-  (simdat$Trial+10)^.75 + rnorm(nrow(simdat))
# principal components analysis:
pca <- prcomp(simdat[, c('Trial', 'predictor')])
# only first PC term contributes:
summary(pca)
# get rotation (weights of predictors in PC):
pcar <- pca$rotation
# add PC1 to data:
simdat$PC1 <- pca$x[,1]

# model:
m1 <- bam(Y ~ Group + te(Time, PC1, by=Group) 
    + s(Time, Subject, bs='fs', m=1, k=5), data=simdat)
# inspect surface:
fvisgam(m1, view=c('Time', 'PC1'), cond=list(Group='Children'),
    rm.ranef=TRUE)
# how does Trial contribute?
plot_pca_surface(m1, pca.term='PC1', weights=pcar[,'PC1'], 
    view=c('Time', 'Trial'), cond=list(Group='Children'),rm.ranef=TRUE)
# Note that the range of Trial is estimated based on the values of PC1.
# A better solution is to specify the range:
plot_pca_surface(m1, pca.term='PC1', weights=pcar[,'PC1'], 
    view=list(Time=range(simdat$Time), Trial=range(simdat$Trial)), 
    cond=list(Group='Children'),rm.ranef=TRUE)

# Partial effects:
pvisgam(m1, view=c('Time', 'PC1'), cond=list(Group='Children'),
    select=1, rm.ranef=TRUE)
# PCA:
plot_pca_surface(m1, pca.term='PC1', weights=pcar[,'PC1'], 
    partial=TRUE, select=1,
    view=list(Time=range(simdat$Time), Trial=range(simdat$Trial)), 
    cond=list(Group='Children'))
}
\concept{Functions for PCA interpretation}
