% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_module.R
\name{eval_module}
\alias{eval_module}
\title{Evaluate a Monte Carlo Model Expression and create an mcmcmodule}
\usage{
eval_module(
  exp,
  data,
  param_names = NULL,
  prev_mcmodule = NULL,
  summary = FALSE,
  mctable = set_mctable(),
  data_keys = set_data_keys(),
  match_keys = NULL
)
}
\arguments{
\item{exp}{Model expression or list of expressions to evaluate}

\item{data}{Input data frame containing model parameters}

\item{param_names}{Named vector for parameter renaming (optional)}

\item{prev_mcmodule}{Previous module(s) for dependent calculations}

\item{summary}{Logical; whether to calculate summary statistics}

\item{mctable}{Monte Carlo configuration table}

\item{data_keys}{List of key columns for each dataset}

\item{match_keys}{Keys to match prev_mcmodule mcnodes and data by}
}
\value{
An mcmodule object containing data, expressions, and nodes
}
\description{
Takes a set of Monte Carlo model expressions and evaluates them and creates an mcmcmodule
containing results and metadata.
}
\examples{
# Basic usage with single expression
eval_module(
  exp = imports_exp,
  data = imports_data,
  mctable = imports_mctable,
  data_keys = imports_data_keys
)
}
