% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{formula_to_mass}
\alias{formula_to_mass}
\title{Calculate the monoisotopic mass from a given formula}
\usage{
formula_to_mass(formula)
}
\arguments{
\item{formula}{A formula as a string.}
}
\value{
The monoisotopic mass of the formula.
}
\description{
Calculates the monoisotopic mass from a given formula. If only the element symbols are provided, the calculated mass corresponds to that of a molecule made up from the most abundant isotopes.
Other isotopes can also be provided (e.g., \if{html}{\out{<sup>}}13\if{html}{\out{</sup>}}C, instead of the naturally most abundant \if{html}{\out{<sup>}}12\if{html}{\out{</sup>}}C). See the samples for details.
}
\examples{
# The monoisotopic mass is calculated with the most abundant isotopes
# if only the element symbols are provided:
formula_to_mass("CH4")
formula_to_mass("NH3")
formula_to_mass("C10H17N3O6S")

# Other isotopes can be provided as follows:
formula_to_mass("[13C]H4")
formula_to_mass("[15N]H3")

# Every isotope, including the most abundant ones, can be named explicitly.
# Compare:
formula_to_mass("[14N][1H]3")
formula_to_mass("NH3")

# The function also supports brackets and nested brackets:
formula_to_mass("(CH3)2")
formula_to_mass("(((CH3)2N)3C)2")
formula_to_mass("((([13C]H3)2N)3C)2")
}
