% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchLoss.R
\docType{data}
\name{mlr3torch_losses}
\alias{mlr3torch_losses}
\title{Loss Functions}
\format{
An object of class \code{DictionaryMlr3torchLosses} (inherits from \code{Dictionary}, \code{R6}) of length 12.
}
\usage{
mlr3torch_losses
}
\description{
Dictionary of torch loss descriptors.
See \code{\link[=t_loss]{t_loss()}} for conveniently retrieving a loss function.
Can be converted to a \code{\link[data.table:data.table]{data.table}} using
\code{\link[data.table:as.data.table]{as.data.table}}.
}
\section{Available Loss Functions}{

cross_entropy, l1, mse
}

\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
mlr3torch_losses$get("mse")
# is equivalent to
t_loss("mse")
# convert to a data.table
as.data.table(mlr3torch_losses)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Torch Descriptor: 
\code{\link{TorchCallback}},
\code{\link{TorchDescriptor}},
\code{\link{TorchLoss}},
\code{\link{TorchOptimizer}},
\code{\link{as_torch_callbacks}()},
\code{\link{as_torch_loss}()},
\code{\link{as_torch_optimizer}()},
\code{\link{mlr3torch_optimizers}},
\code{\link{t_clbk}()},
\code{\link{t_loss}()},
\code{\link{t_opt}()}

Other Dictionary: 
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr3torch_optimizers}},
\code{\link{t_opt}()}
}
\concept{Dictionary}
\concept{Torch Descriptor}
\keyword{datasets}
