% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom-tol.R
\name{reset_tol}
\alias{reset_tol}
\alias{reset_rtol}
\alias{reset_atol}
\title{Reset all model tolerances}
\usage{
reset_tol(x, rtol = NULL, atol = NULL)

reset_rtol(x, rtol = NULL)

reset_atol(x, atol = NULL)
}
\arguments{
\item{x}{a model object.}

\item{rtol}{global relative tolerance for both scalar and customized
configurations; if not supplied, the current model's scalar \code{rtol} value is
used.}

\item{atol}{global absolute tolerance for both scalar and customized
configurations; if not supplied, the current model's scalar \code{atol} value is
used.}
}
\value{
An updated model object.
}
\description{
These functions reset both scalar and customized values for both
relative and absolute tolerances. All functions reset tolerances to a single,
common \code{rtol} or \code{atol}.  The functions do \emph{not} change which tolerance
configuration is used for simulation (e.g., scalar or customized); see
\code{\link[=use_custom_tol]{use_custom_tol()}} and \code{\link[=use_scalar_tol]{use_scalar_tol()}} to make that change in the model
object.
}
\examples{
mod <- house()
mod <- reset_tol(mod, rtol = 1e-6, atol = 1e-10)
mod

}
\seealso{
\code{\link[=custom_tol]{custom_tol()}}, \code{\link[=use_custom_tol]{use_custom_tol()}}, \code{\link[=use_scalar_tol]{use_scalar_tol()}}, \code{\link[=get_tol]{get_tol()}}
}
