% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{abs_to_ratio}
\alias{abs_to_ratio}
\title{Convert absolute quantitation to relative ratios.}
\usage{
abs_to_ratio(x, method = "first")
}
\arguments{
\item{x}{vector of numeric absolute quantitation values}

\item{method}{method to use to determine starting value (denominator)}
}
\value{
A numeric vector of the same length as input
}
\description{
\code{abs_to_ratio} takes a vector of absolute values and
returns a vector of ratios relative to some starting point.
}
\details{
The denominator used to calculate relative protein concentrations
  can affect the ability to model noisy data. In the theoretically ideal
  scenario, everything would be relative to the lowest temperature point.
  However, other methods can be used to help alleviate problems related to
  noise. Available methods include:
    \describe{
       \item{"first"}{Use the first value (lowest temperature point)
         (default)}
       \item{"max"}{Use the maximum value}
       \item{"top3"}{Use the mean of the three highest values}
       \item{"near"}{Use the median of all values greater than 80% of
         the first value}
    }
}
\keyword{internal}
