% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{normalize_to_profile}
\alias{normalize_to_profile}
\title{Normalize to a profile.}
\usage{
normalize_to_profile(replicate, profile, model = T, plot = T)
}
\arguments{
\item{replicate}{an MSThermReplicate object}

\item{profile}{a vector of relative values}

\item{model}{whether to fit scale factors to model}

\item{plot}{(T/f) whether to display a summary plot}
}
\value{
An MsThermReplicate object with normalized data slots
}
\description{
Normalizes an MSThermReplicate based on a pre-determined
vector of relative abundances
}
\examples{
control <- system.file("extdata", "demo_project/control.tsv", package="mstherm")
annots  <- system.file("extdata", "demo_project/annots.tsv",  package="mstherm")
expt    <- MSThermExperiment(control, annotations=annots)

profile <- c(50.0, 50.5, 47.5, 42.0, 37.0, 25.0, 16.0, 11.5, 10.5, 10.0)
expt$samples$Control$replicates$C1 <- normalize_to_profile(
   expt$samples$Control$replicates$C1, profile, plot=FALSE
)

}
