% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitCube_Genz1.R
\docType{class}
\name{unitCube_Genz1-class}
\alias{unitCube_Genz1-class}
\alias{unitCube_Genz1}
\title{An S4 class to represent the function \eqn{\cos\left(2\pi u + \sum^{n}_{i=1} a_i x_i \right)} on \eqn{[0,1]^n}}
\description{
Implementation of the function
\deqn{f \colon [0,1]^n \to (-\infty,\infty),\, \vec{x} \mapsto f(\vec{x}) = \cos\left(2\pi u + \sum^{n}_{i=1} a_i x_i \right)},
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{C_n = [0,1]^n}.
The integral is known to be
\deqn{\int_{C_n} f(\vec{x}) d\vec{x} = \frac{2^n \cos\left(2\pi u + \sum_{i=1}^{n}a_i/2\right) \prod_{i=1}^n \sin(a_i/2)}{\prod_{i=1}^n a_i}.}
}
\details{
The instance needs to be created with three parameter representing the dimension \eqn{n}, the real number \eqn{u} and the vector \eqn{(a_1,...,a_n)}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{u}}{A real number representing a shift in the integrand}

\item{\code{a}}{A vector of real numbers, each non-zero, increasing the difficulty of the integrand with higher absolute values}
}}

\examples{
n <- as.integer(3)
u <- pi
a <- rep(exp(1),n)
f <- new("unitCube_Genz1",dim=n, u=u, a=a)
}
\author{
Klaus Herrmann
}
