% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{mc_filter}
\alias{mc_filter}
\title{Filter data from myClim object}
\usage{
mc_filter(
  data,
  localities = NULL,
  logger_types = NULL,
  loggers = NULL,
  sensors = NULL,
  reverse = FALSE,
  stop_if_empty = TRUE
)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{localities}{locality_ids for filtering data; if NULL then do nothing (default NULL)}

\item{logger_types}{types of logger for filtering data; if NULL then do nothing (default NULL).
The logger_types parameter can by used only for raw data format see \link{myClim-package}.}

\item{loggers}{logger_names for filtering data; if NULL then do nothing (default NULL).
The loggers parameter can by used only for raw data format see \link{myClim-package}.}

\item{sensors}{sensor_names for filtering data; if NULL then do nothing see \code{names(mc_data_sensors)} (default NULL)}

\item{reverse}{if TRUE then input localities and/or sensors are excluded (default FALSE)}

\item{stop_if_empty}{if TRUE then error for empty output (default TRUE)}
}
\value{
filtered myClim object
}
\description{
This function filter data by localities, logger types and sensors.
}
\details{
In default settings it returns the object containing input localities / logger types / loggers / sensors.
When you provide vector of localities e.g. \code{localities=c("A6W79", "A2E32")}
selected localities are filtered with all loggers / sensors on those localities.
When you provide vector of loggers e.g. \code{loggers=c("TMS_1", "TMS_2")}
selected loggers are filtered through all localities.
The same as When you provide vector of logger_types \code{logger_types=c("TMS", "TMS_L45")}
selected loggers by type are filtered through all localities.
(loggers or logger_types criterion is applicable only for raw data format see \link{myClim-package}) and
the sensors parameter \code{sensors=c("TMS_T1", "TMS_T2")},
selected sensors are filtered through all localities.
When you combine localities, logger_types/loggers and sensors, then filtering return
selected sensors in selected loggers on selected localities.

Parameter \code{reverse = TRUE} returns myClim object complemented to object filtered by parameter \code{reverse = FALSE}.
\itemize{
\item \code{reverse = TRUE} and \code{localities} are selected then the listed localities are removed from myClim object.
\item \code{reverse = TRUE} and \code{loggers} are selected then the listed loggers are removed from all localities.
\item \code{reverse = TRUE} and \code{logger_types} are selected then the listed logger types are removed from all localities.
\item \code{reverse = TRUE} and \code{sensors} are selected then listed sensors are removed from all loggers / localities.
\item \code{reverse = TRUE} and \code{localities} and \code{loggers} are selected then the listed loggers are removed only from listed localities.
}

Only one of parameters loggers or logger_types can be used.
}
\examples{
## keep only "A6W79", "A2E32" localities with all their sensors
filtered_data <- mc_filter(mc_data_example_raw, localities=c("A6W79", "A2E32"))

## remove "A6W79", "A2E32" localities and keep all others
filtered_data <- mc_filter(mc_data_example_raw, localities=c("A6W79", "A2E32"), reverse=TRUE)

## keep only "TMS_T1", and "TMS_T2" sensors on all localities
filtered_data <- mc_filter(mc_data_example_raw, sensors=c("TMS_T1", "TMS_T2"))

## remove "TMS_T1", and "TMS_T2" sensors from all localities
filtered_data <- mc_filter(mc_data_example_raw, sensors=c("TMS_T1", "TMS_T2"),reverse=TRUE)

## keep only "TMS_T1", and "TMS_T2" sensors on "A6W79", "A2E32" localities
filtered_data <- mc_filter(mc_data_example_raw, localities=c("A6W79", "A2E32"),
                           sensors=c("TMS_T1", "TMS_T2"))
## Remove "Dendro" loggers on all localities
filtered_data <- mc_filter(mc_data_example_raw, logger_types="Dendro", reverse=TRUE)
}
