% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageChildren.R
\name{ageChildren}
\alias{ageChildren}
\title{Goodness of fit to an expected model-based age distribution}
\usage{
ageChildren(age, u5mr = 1)
}
\arguments{
\item{age}{A vector of ages. Should either be in whole months (integer) or in
calculated decimal months (numeric).}

\item{u5mr}{A numeric value for under five years mortality rate expressed as
deaths / 10,000 persons / day. Default is set to 1.}
}
\value{
A list of class "ageChildren" with:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{u5mr} \tab Under five years mortality rate as deaths / 10000 persons / day \cr
   \emph{observed} \tab Table of counts in each (year-centred) age group \cr
   \emph{expected} \tab Table of expected counts in each (year-centred) age group \cr
   \emph{X2} \tab Chi-squared test statistic \cr
   \emph{df} \tab Degrees of freedom for Chi-squared test \cr
   \emph{p} \tab p-value for Chi-squared test \cr
}
}
\description{
A simple model-based method for calculating expected numbers using
exponential decay in a population in which births and deaths balance each
other and with a 1:1 male to female sex ratio. This function is built
specifically to test goodness of fit for a sample of children aged 6-59
months old grouped into four 1 year age groups and 1 half year age group
(6 to less than 18 months, 18 to less than 30 months, 30 to less than 42
months, 42 to less than 54 months, and 54 months to less than 60 months).
}
\examples{
# Chi-Squared test for age of children in dp.ex02 sample dataset using an
# u5mr of 1 / 10,000 / day.
svy <- dp.ex02
ac <- ageChildren(svy$age, u5mr = 1)
ac

# Apply function to each sex separately
# Males
acM <- ageChildren(svy$age[svy$sex == 1], u5mr = 1)
acM
# Females
acF <- ageChildren(svy$age[svy$sex == 2], u5mr = 1)

# Simplified call to function by sex
by(svy$age, svy$sex, ageChildren, u5mr = 1)

}
