% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digitPreference.R
\name{digitPreference}
\alias{digitPreference}
\title{Digit preference test}
\usage{
digitPreference(x, digits = 1, values = 0:9)
}
\arguments{
\item{x}{Numeric vector of measurements}

\item{digits}{Number of decimal places in \code{x}. Using \code{digits = 1}
(e.g.) allows 105 to be treated as 105.0}

\item{values}{A vector of possible values for the final digit (default = 0:9)}
}
\value{
A list of class \code{"digitPreference"} with:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{dps} \tab Digit Preference Score (DPS) \cr
   \emph{tab} \tab Table of final digit counts \cr
   \emph{pct} \tab Table of proportions (\\\%) of final digit counts \cr
}
}
\description{
Digit preference is the observation that the final number in a measurement
occurs with a greater frequency that is expected by chance. This can occur
because of rounding, the practice of increasing or decreasing the value in a
measurement to the nearest whole or half unit, or because data are made up.
The \code{\link[=digitPreference]{digitPreference()}} function assesses the level by which digit
preference exists in a given dataset using a \verb{digit preference score (DPS)}.
}
\details{
DPS definition from:

\cite{Kari Kuulasmaa K, Hense HW, Tolonen H (for the WHO MONICA Project),
Quality Assessment of Data on Blood Pressure in the WHO MONICA Project,
WHO MONICA Project e-publications No. 9, WHO, Geneva, May 1998 available
from \url{https://www.thl.fi/publications/monica/bp/bpqa.htm}}
}
\examples{
# Digit preference test applied to anthropometric data from a single state
# from a DHS survey in a West African country
svy <- dp.ex01
digitPreference(svy$wt, digits = 1)

}
