% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewKurt.R
\name{skewKurt}
\alias{skewKurt}
\title{Skew and kurtosis}
\usage{
skewKurt(x)
}
\arguments{
\item{x}{Numeric vector}
}
\value{
A list of class "skewKurt" with:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{s} \tab Skewness with direction \cr
   \emph{s.se} \tab Standard error of skewness \cr
   \emph{s.z} \tab Test statistic (\code{s.z = s / s.se}) \cr
   \emph{s.p} \tab \code{p-value} (\code{s != 0}) \cr
   \emph{k} \tab Excess kurtosis with direction \cr
   \emph{k.se} \tab Standard error of excess kurtosis \cr
   \emph{k.z} \tab Test statistic (\code{k.z = k / k.se}) \cr
   \emph{k.p} \tab \code{p-value} (\code{k != 0}) \cr
}
}
\description{
Skew and kurtosis
}
\examples{
# Use skewKurt() on an anthropometric data from a SMART survey in
# Kabul, Afghanistan (dist.ex01)
svy <- dist.ex01
skewKurt(svy$muac)

}
