% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNuPrime.R
\name{getNuPrime}
\alias{getNuPrime}
\title{Calculate the Derivate of Nu}
\usage{
getNuPrime(alpha, conditionalPower)
}
\arguments{
\item{alpha}{The (conditional) type I error rate of the design. Must be a numeric vector with values between 0 and 1.}

\item{conditionalPower}{The target conditional power \eqn{CP} of the design. Must be a numeric value.}
}
\value{
Value for nu prime.
}
\description{
Calculates the derivative of nu for a given conditional error and conditional power.
}
\details{
The function \eqn{\nu'} is defined as
\deqn{\nu'(p_1) = -2 \cdot (\Phi^{-1}(1-\alpha_2(p_1)) + \Phi^{-1}(CP))/\phi(\Phi^{-1}(1-\alpha_2(p_1))).}
Note that in this implementation, the the factor -2 is used instead of -4, which is used in by Brannath & Bauer (2004), who explicitly investigate the setting of a balanced two-group trial.
The argument \code{conditionalPower} is either the fixed target conditional power or the value of the conditional power function at the corresponding first-stage p-value.
}
\examples{
getNuPrime(alpha = 0.05, conditionalPower = 0.9)

}
\references{
Brannath, W. & Bauer, P. (2004). Optimal conditional error functions for the control of conditional power. Biometrics. https://www.jstor.org/stable/3695393
}
