% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qtest.R
\name{Qtest}
\alias{Qtest}
\title{Model Fit based on Person Fit Index Q}
\usage{
Qtest(
  obj = NULL,
  data = NULL,
  threshold = NULL,
  split = "median",
  splitseed = "no",
  ...
)
}
\arguments{
\item{obj}{an object of class \code{"pers"} or class \code{"pair"}as a result from function \code{\link{pers}} or \code{\link{pair}} respectively.}

\item{data}{optional response data when object of class \code{"pers"} or class \code{"pair"} is not provided.}

\item{threshold}{optional in case that object of class \code{"pers"} or class \code{"pair"} is not provided. Threshold values as matrix with row and columnnames !! -- items as rows and thresholds as columns. Thresholds should be ordered from left to right, some items may have less thresholds than the others, in this case the respective row/column is filled with an NA value - see examples.}

\item{split}{Specifies the splitting criterion. Basically there are three different options available - each with several modes - which are controlled by passing the corresponding character expression to the argument. 

1) Using the rawscore for splitting into subsamples with the following modes: \code{split = "median"} median raw score split - high score group and low score group; \code{split = "mean"} mean raw score split - high score group and low score group.
Finaly \code{split = "score"} that is splitting \code{daten} into as many subsamples as there are raw score groups - discarding min and max (theoretical) score group - which matches the concept proposed by Andersen (1973).

2) Dividing the persons in \code{daten} into subsamples with equal size by random allocation with the following modes: \code{split = "random"} (which is equivalent to \code{split = "random.2"}) divides persons into two subsamples with equal size. In general the number of desired subsamples must be expressed after the dot in the character expression - e.g. \code{split = "random.6"} divides persons into 6 subsamples (with equal size) by random allocation etc. 

3) The third option is using a manifest variable as a splitting criterion. In this case a vector with the same length as number of cases in \code{daten} must be passed to the argument grouping the data into subsamples. This vector should be coded as \code{"factor"} or a \code{"numeric"} integer vector with min = 1.}

\item{splitseed}{numeric, used for \code{set.seed(splitseed)} for random splitting - see argument \code{split}.}

\item{...}{not used so far.}
}
\value{
A list with class "htest" containing the following components as returned by \code{\link{kruskal.test}}.
}
\description{
function for performing a model fit test based on calculating the person fit index \code{\link{Q}} for sub samples. Persons are ranked according their fit and in turn a Kruskal-Wallis rank sum test (see \code{\link{kruskal.test}}) is performed to test if the parameters of the distribution of Q are the same in each group (sample).
}
\details{
The person Q-index proposed by Tarnai and Rost, (1990) is solely based on the empirical responses and the item parameters. Thus the computation of person parameters using the function \code{\link{pers}} is not required - see examples. But for convenience return objects of both functions are accepted in function \code{Q}. This offers the opportunity to get some inference on model fit only based on item parameters.
}
\examples{
#######################
data(bfiN) # get some data
ip <- pair(daten = bfiN,m = 6) # item parameters according the partial credit model
Q(ip)

Qtest(ip)

### with data an thresholds as external objects #####
threshold <- matrix(seq(-3,3,length.out = 9),ncol = 3)
dimnames(threshold) <- list(c("I1","I2","I3"),c("1","2","2"))
threshold
resp_vec <- c(3,0,2,1,2,2,2,2,1,3,0,NA,NA,0,2,3,NA,2,NA,2,1,2,NA,1,2,2,NA)
resp_emp <- matrix(resp_vec,ncol = 3,byrow = TRUE)
colnames(resp_emp) <- c("I1","I2","I3")
resp_emp
Qindex <- Q(data = resp_emp,threshold = threshold)
cbind(resp_emp,Qindex)

Qtest_res <- Qtest(data = resp_emp,threshold = threshold)
Qtest_res

#### unequal number of thresholds ###################
threshold <- matrix(seq(-3,3,length.out = 9),ncol = 3)
dimnames(threshold) <- list(c("I1","I2","I3"),c("1","2","2"))
threshold[2,3] <- NA

resp_vec <- c(3,0,2,1,2,2,2,2,1,3,0,NA,NA,0,2,3,NA,2,NA,2,1,2,NA,1,2,2,NA)
resp_emp <- matrix(resp_vec,ncol = 3,byrow = TRUE)
colnames(resp_emp) <- c("I1","I2","I3")
resp_emp
Qindex <- Q(data = resp_emp,threshold = threshold)
cbind(resp_emp,Qindex)

Qtest_res <- Qtest(data = resp_emp,threshold = threshold)
Qtest_res
}
\references{
Tarnai, C., & Rost, J. (1990). \emph{Identifying aberrant response patterns in the Rasch model: the Q index}. Münster: ISF.

Andersen, E. B. (1973). A goodness of fit test for the rasch model. \emph{Psychometrika, 38}(1), 123–140.
}
\keyword{fit}
\keyword{model}
\keyword{person}
