% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_moderators.R
\name{plot_moderator_c_loess}
\alias{plot_moderator_c_loess}
\title{LOESS plot of a continuous moderating variable}
\usage{
plot_moderator_c_loess(.model, moderator, line_color = "blue")
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}

\item{moderator}{the moderator as a vector}

\item{line_color}{the color of the loess line}
}
\value{
ggplot object
}
\description{
Plot the LOESS prediction of ICATEs by a continuous covariate. This is an alternative to partial dependency plots to assess treatment effect heterogeneity by a continuous covariate. See Carnegie, Dorie and Hill 2019.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSuprule = 'none'
)
plot_moderator_c_loess(model_results, lalonde$age)
}
}
\references{
Carnegie, N., Dorie, V., & Hill, J. L. (2019).
Examining treatment effect heterogeneity using BART.
Observational Studies, 5(2), 52-70.
}
\author{
George Perrett, Joseph Marlo
}
