% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normRes_tests.R
\name{normRes_tests}
\alias{normRes_tests}
\title{Test the location and scale parameters from a normalization procedure}
\usage{
normRes_tests(norm_obj, test_fn = "kw")
}
\arguments{
\item{norm_obj}{object of class 'pepData', 'proData', 'lipidData',
'metabData', 'isobaricpepData', or 'nmrData' that has had \code{normalize_global()} run
on it, or a 'normRes' object}

\item{test_fn}{character string indicating the statistical test to use.
Current options are "anova" and "kw" for a Kruskal-Wallis test.}
}
\value{
A list with 2 entries containing the p_value of the test performed on
  the location and scale (if it exists) parameters.
}
\description{
Computes p-values from a test of dependence between normalization parameters
and group assignment of a normalized omicsData or normRes object
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mymetab <- edata_transform(omicsData = metab_object, data_scale = "log2")
mymetab <- group_designation(omicsData = mymetab, main_effects = "Phenotype")

# provide the normRes object
mynorm <- normalize_global(omicsData = mymetab, subset_fn = "all",
                           norm_fn = "median", apply_norm = FALSE)
norm_pvals <- normRes_tests(norm_obj = mynorm)

# provide normalized omicsData object
mymetab <- normalize_global(omicsData = mymetab, subset_fn = "all",
                            norm_fn = "median", apply_norm = TRUE)
norm_pvals <- normRes_tests(norm_obj = mymetab)

# NMR data object
mynmr <- edata_transform(omicsData = nmr_identified_object, data_scale = "log2")
mynmr <- group_designation(mynmr, main_effects = "Condition")
mynmrnorm <- normalize_nmr(
  omicsData = mynmr,
  apply_norm = TRUE,
  sample_property_cname = "Concentration"
)
mynmrnorm <- normalize_global(omicsData = mynmrnorm, subset_fn = "all",
                              norm_fn = "median", apply_norm = TRUE, backtransform = TRUE)
norm_pvals <- normRes_tests(norm_obj = mynmrnorm)
\dontshow{\}) # examplesIf}
}
