% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.corRes}
\alias{plot.corRes}
\title{Plot corRes Object}
\usage{
\method{plot}{corRes}(
  x,
  omicsData = NULL,
  order_by = NULL,
  colorbar_lim = c(NA, NA),
  x_text = TRUE,
  y_text = TRUE,
  interactive = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = 90,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "right",
  color_low = NULL,
  color_high = NULL,
  bw_theme = TRUE,
  use_VizSampNames = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class "corRes" created via \code{cor_result}}

\item{omicsData}{an object of the class 'pepData', 'isobaricpepData',
'proData', 'lipidData', 'metabData', 'nmrData' or 'seqData' created via
\code{\link{as.pepData}}, \code{\link{as.isobaricpepData}},
\code{\link{as.proData}}, \code{\link{as.lipidData}},
\code{\link{as.metabData}}, \code{\link{as.nmrData}}, or
\code{\link{as.seqData}}, respectively.}

\item{order_by}{A character string specifying a column in f_data by which to
order the samples.}

\item{colorbar_lim}{A pair of numeric values specifying the minimum and
maximum values to use in the heat map color bar. Defaults to 'c(NA, NA)',
in which case ggplot2 automatically sets the minimum and maximum values
based on the correlation values in the data.}

\item{x_text}{logical value. Indicates whether the x-axis will be labeled
with the sample names. The default is TRUE.}

\item{y_text}{logical value. Indicates whether the y-axis will be labeled
with the sample names. The default is TRUE.}

\item{interactive}{logical value. If TRUE produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label}

\item{y_lab}{character string specifying the y-axis label}

\item{x_lab_size}{integer value indicating the font size for the x-axis.
The default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis.
The default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels.
The default is 90.}

\item{title_lab}{character string specifying the plot title}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title.}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", "bottom", or "none". The
default is "none".}

\item{color_low}{character string specifying the color of the gradient for
low values}

\item{color_high}{character string specifying the color of the gradient for
high values}

\item{bw_theme}{logical value. If TRUE uses the ggplot2 black and white theme.}

\item{use_VizSampNames}{logical value. Indicates whether to use custom sample
names. The default is FALSE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
For plotting an S3 object of type 'corRes'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mymetab <- edata_transform(omicsData = metab_object, data_scale = "log2")
mymetab <- group_designation(omicsData = mymetab, main_effects = "Phenotype")
my_correlation <- cor_result(omicsData = mymetab)
plot(my_correlation, omicsData = mymetab, order_by = "Phenotype")

\donttest{
myseq_correlation <- cor_result(omicsData = rnaseq_object)
plot(myseq_correlation)
}
\dontshow{\}) # examplesIf}
}
