% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_variable1.R
\name{px_variable_type}
\alias{px_variable_type}
\alias{px_variable_type.px}
\title{VARIABLE-TYPE}
\usage{
px_variable_type(x, value, validate)

\method{px_variable_type}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{A data frame with columns 'variable-code' and 'variable-type'.
If value is missing, the current VARIABLE-TYPE is returned. If NULL, all
VARIABLE-TYPE is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or data frame.
}
\description{
Inspect or change VARIABLE-TYPE.
}
\examples{
library(tibble)

# Set VARIABLE-TYPE
x1 <-
  px(population_gl) |>
  px_variable_type(tibble('variable-code' = 'year', 'variable-type' = 'time'))

# Print VARIABLE-TYPE
px_variable_type(x1)

# Remove VARIABLE-TYPE
x2 <- px_variable_type(x1, NULL)
px_variable_type(x2)

}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A56\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C499\%2C0\%5D}{Statistics Sweden's documentation}
}
