% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_predictive_diagnostics.R
\name{prior_pp_diagnostics}
\alias{prior_pp_diagnostics}
\title{Prior predictive diagnostics and sensibility report}
\usage{
prior_pp_diagnostics(
  object,
  level = 0.95,
  support = NULL,
  lower = NULL,
  upper = NULL,
  trials = NULL,
  plausible_lower = NULL,
  plausible_upper = NULL,
  include_observed = TRUE,
  seed = NULL
)
}
\arguments{
\item{object}{A qbrms prior object: qbrms_prior_fit, qbrms_prior_only, or a qbrms_fit
that contains \code{prior_samples}.}

\item{level}{Credible level for central intervals (default 0.95). Reserved.}

\item{support}{Optional override of the implied support: one of "real",
"positive", "proportion", or "bounded". If \code{NULL}, an attempt is made
to infer from the family.}

\item{lower, upper}{Optional numeric bounds used when \code{support = "bounded"}.
If \code{support = "proportion"}, the default is \code{c(0, 1)}.}

\item{trials}{Optional integer vector for binomial data (bounds helper).}

\item{plausible_lower, plausible_upper}{Optional numeric bounds defining a user-declared
“plausible range” for the outcome on the response scale. When both are supplied,
the function reports the fraction of prior-predictive mass that falls in
\code{[plausible_lower, plausible_upper]} and incorporates this into the verdict.}

\item{include_observed}{Logical; if \code{TRUE} and the object contains data,
the report compares simple statistics of \code{y} to their prior-predictive
reference distributions.}

\item{seed}{Optional seed for reproducibility.}
}
\value{
An object of class \code{qbrms_prior_diagnostics}.
}
\description{
Summarise prior predictive draws to check basic support, scale and shape,
and (optionally) how simple statistics of the observed data compare with
the prior-predictive distribution. Returns an object with a concise verdict.
}
