% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.cv.rbridge}
\alias{coef.cv.rbridge}
\title{Extract coefficients from a 'cv.rbridge' object}
\usage{
\method{coef}{cv.rbridge}(object, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{A 'cv.rbridge' object.}

\item{s}{Value(s) of the penalty parameter lambda at which predictions are required.}

\item{...}{Additional arguments for compatibility.}
}
\value{
A vector of coefficients
}
\description{
Extract coefficients from a 'cv.rbridge' object.
}
\examples{
set.seed(2019) 
beta <- c(3, 1.5, 0, 0, 2, 0, 0, 0)
p <- length(beta)
beta <- matrix(beta, nrow = p, ncol = 1)

### Restricted Matrix and vector
c1 <- c(1,1,0,0,1,0,0,0)
R1.mat <- matrix(c1,nrow = 1, ncol = p)
r1.vec <- as.matrix(c(6.5),1,1)

n = 100
X = matrix(rnorm(n*p),n,p)
y = X\%*\%beta + rnorm(n) 

######## Model 1 based on first restrictions
model1 <- cv.rbridge(X, y, q = 1, R1.mat, r1.vec)
coef(model1,s='lambda.min')
}
\seealso{
\code{\link{predict.cv.rbridge}}
}
\author{
Bahadir Yuzbasi, Mohammad Arashi and Fikri Akdeniz \cr Maintainer: Bahadir Yuzbasi \email{b.yzb@hotmail.com}
}
