% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.bridge.R
\name{cv.bridge}
\alias{cv.bridge}
\title{Cross-validation for bridge}
\usage{
cv.bridge(X, y, q, lambda, nfolds = 10, lambda.min = ifelse(n > p,
  0.001, 0.05), nlambda = 100, eta = 1e-07, converge = 10^10,
  num_threads = 10)
}
\arguments{
\item{X}{\code{X} matrix as in bridge.}

\item{y}{response \code{y} as in bridge.}

\item{q}{is the degree of norm which includes ridge regression with \code{q=2} and lasso estimates with \code{q=1} as special cases}

\item{lambda}{lambda sequence; default is NULL. It is given by user or \code{cv.rbridge} chooses its own sequence.}

\item{nfolds}{number of folds - default is 10.}

\item{lambda.min}{The smallest value for lambda if \code{n>p} is \code{0.001} and \code{0.05} otherwise.}

\item{nlambda}{The number of lambda values - default is \code{100}}

\item{eta}{is a preselected small positive threshold value. It is deleted \code{jth} variable to make the algorithm stable and also is excluded \code{jth} variable from the final model. Default is \code{1e-07}.}

\item{converge}{is the value of converge. Defaults is \code{10^10}. In each iteration, it is calculated by sum of square the change in linear predictor for each coefficient. The algorithm iterates until \code{converge > eta}.}

\item{num_threads}{Number of threads used for parallel computation over the folds,}
}
\value{
An object of class rbridge, a list with entries
\item{cve}{the mean cross-validated error.}
\item{cvse}{estimate of standard error of \code{cvm}.}
\item{cvup}{upper curve = \code{cvm+cvsd}.}
\item{cvlo}{lower curve = \code{cvm-cvsd}.}
\item{lambda}{the values of \code{lambda} used in the fits}
\item{nz}{number of non-zero coefficients at each \code{lambda}.}
\item{betas}{estimated coefficient at each \code{lambda}.}
\item{lambda.min}{value of lambda that gives minimum \code{cve}}
\item{lambda.1se}{largest value of \code{lambda} such that error is within 1 standard error of the minimum}
}
\description{
Does k-fold cross-validation for bridge, produces a plot, and returns a value for lambda
}
\details{
Computes bridge
}
\examples{
set.seed(2019) 
beta <- c(3, 1.5, 0, 0, 2, 0, 0, 0)
p <- length(beta)
beta <- matrix(beta, nrow = p, ncol = 1)

n = 100
X = matrix(rnorm(n*p),n,p)
y = X\%*\%beta + rnorm(n) 

######## Model 1 
model1 <- cv.bridge(X, y, q = 1)
print(model1)
coef(model1,s='lambda.min')
predict(model1,newx=X[1:5,], s="lambda.min", type="response")
predict(model1, s="lambda.min",type="coefficient")

######## Model 2 
model2 <- cv.bridge(X, y, q = 2)
print(model2)
coef(model2,s='lambda.min')
predict(model2,newx=X[1:5,], s="lambda.min", type="response")
predict(model2, s="lambda.min",type="coefficient")

}
\seealso{
\code{\link{bridge}}
}
\author{
Bahadir Yuzbasi, Mohammad Arashi and Fikri Akdeniz \cr Maintainer: Bahadir Yuzbasi \email{b.yzb@hotmail.com}
}
