/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.font.FontIncluder;

public abstract class FontEmbedder
extends FontIncluder {
    public static final String NOTDEF = ".notdef";
    private double[] widths;
    private GlyphVector glyphs;
    private Font font;

    protected abstract void writeGlyph(String var1, Shape var2, GlyphMetrics var3) throws IOException;

    protected abstract void writeWidths(double[] var1) throws IOException;

    protected void openGlyphs() throws IOException {
    }

    protected void closeGlyphs() throws IOException {
    }

    protected abstract void closeEmbedFont() throws IOException;

    public FontEmbedder(FontRenderContext context) {
        super(context);
    }

    protected double[] getAdvanceWidths() {
        if (this.widths == null) {
            this.widths = new double[256];
            for (int i = 0; i < this.widths.length; ++i) {
                this.widths[i] = this.glyphs.getGlyphMetrics(i).getAdvance();
                if (this.getCharName(i) != null) continue;
                this.widths[i] = this.getUndefinedWidth();
            }
        }
        return this.widths;
    }

    protected double getAdvanceWidth(int character) {
        return this.getAdvanceWidths()[character];
    }

    protected Shape getGlyph(int i) {
        FontRenderContext orig = this.getContext();
        FontRenderContext frc = new FontRenderContext(null, orig.isAntiAliased(), orig.usesFractionalMetrics());
        Shape shape = this.font.createGlyphVector(frc, new char[]{this.getUnicode(i)}).getGlyphOutline(0);
        return orig.getTransform().createTransformedShape(shape);
    }

    protected GlyphMetrics getGlyphMetrics(int i) {
        return this.glyphs.getGlyphMetrics(i);
    }

    @Override
    public void includeFont(Font font, CharTable charTable, String name) throws IOException {
        this.glyphs = null;
        this.widths = null;
        this.font = font;
        super.includeFont(font, charTable, name);
        this.glyphs = font.createGlyphVector(this.getContext(), this.getUnicode());
        this.writeWidths(this.getAdvanceWidths());
        try {
            this.openGlyphs();
            for (int i = 0; i < 256; ++i) {
                if (this.getCharName(i) == null) continue;
                this.writeGlyph(this.getCharName(i), this.getGlyph(i), this.getGlyphMetrics(i));
            }
            this.writeGlyph(NOTDEF, this.createUndefined(), null);
            this.closeGlyphs();
            this.closeEmbedFont();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Shape createUndefined() {
        GeneralPath ud = new GeneralPath(0, 10);
        ud.append(new Rectangle2D.Double(0.0, 0.0, 1000.0, 1000.0), false);
        ud.append(new Rectangle2D.Double(50.0, 50.0, 900.0, 900.0), false);
        return ud;
    }
}

