/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.graph.Matching;
import org.openscience.cdk.group.DisjointSetForest;

final class EdmondsMaximumMatching {
    private final int[][] graph;
    private final Matching matching;
    private final BitSet subset;
    private final int[] even;
    private final int[] odd;
    private static final int NIL = -1;
    private final List<Integer> queue;
    private DisjointSetForest dsf;
    private final Map<Integer, Tuple> bridges = new HashMap<Integer, Tuple>();
    private final int[] path;
    private final BitSet vAncestors;
    private final BitSet wAncestors;

    private EdmondsMaximumMatching(int[][] graph, Matching matching, BitSet subset) {
        this.graph = graph;
        this.matching = matching;
        this.subset = subset;
        this.even = new int[graph.length];
        this.odd = new int[graph.length];
        this.queue = new LinkedList<Integer>();
        this.dsf = new DisjointSetForest(graph.length);
        this.path = new int[graph.length];
        this.vAncestors = new BitSet(graph.length);
        this.wAncestors = new BitSet(graph.length);
        while (this.augment()) {
        }
    }

    private boolean augment() {
        int v;
        Arrays.fill(this.even, -1);
        Arrays.fill(this.odd, -1);
        this.dsf = new DisjointSetForest(this.graph.length);
        this.bridges.clear();
        this.queue.clear();
        for (v = 0; v < this.graph.length; ++v) {
            if (!this.subset.get(v) || !this.matching.unmatched(v)) continue;
            this.even[v] = v;
            this.queue.add(v);
        }
        while (!this.queue.isEmpty()) {
            v = this.queue.remove(0);
            for (int w : this.graph[v]) {
                if (!this.subset.get(w)) continue;
                if (this.even[this.dsf.getRoot(w)] != -1) {
                    if (!this.check(v, w)) continue;
                    return true;
                }
                if (this.odd[w] != -1) continue;
                this.odd[w] = v;
                int u = this.matching.other(w);
                if (this.even[this.dsf.getRoot(u)] != -1) continue;
                this.even[u] = w;
                this.queue.add(u);
            }
        }
        return false;
    }

    private boolean check(int v, int w) {
        if (this.dsf.getRoot(v) == this.dsf.getRoot(w)) {
            return false;
        }
        this.vAncestors.clear();
        this.wAncestors.clear();
        int vCurr = v;
        int wCurr = w;
        do {
            if ((vCurr = this.parent(this.vAncestors, vCurr)) == (wCurr = this.parent(this.wAncestors, wCurr))) {
                this.blossom(v, w, vCurr);
                return false;
            }
            if (this.dsf.getRoot(this.even[vCurr]) == vCurr && this.dsf.getRoot(this.even[wCurr]) == wCurr) {
                this.augment(v);
                this.augment(w);
                this.matching.match(v, w);
                return true;
            }
            if (!this.wAncestors.get(vCurr)) continue;
            this.blossom(v, w, vCurr);
            return false;
        } while (!this.vAncestors.get(wCurr));
        this.blossom(v, w, wCurr);
        return false;
    }

    private int parent(BitSet ancestors, int curr) {
        curr = this.dsf.getRoot(curr);
        ancestors.set(curr);
        int parent = this.dsf.getRoot(this.even[curr]);
        if (parent == curr) {
            return curr;
        }
        ancestors.set(parent);
        return this.dsf.getRoot(this.odd[parent]);
    }

    private void blossom(int v, int w, int base) {
        base = this.dsf.getRoot(base);
        int[] supports1 = this.blossomSupports(v, w, base);
        int[] supports2 = this.blossomSupports(w, v, base);
        for (int k : supports1) {
            this.dsf.makeUnion(k, supports1[0]);
        }
        for (int j : supports2) {
            this.dsf.makeUnion(j, supports2[0]);
        }
        this.even[this.dsf.getRoot((int)base)] = this.even[base];
    }

    private int[] blossomSupports(int v, int w, int base) {
        int n = 0;
        this.path[n++] = this.dsf.getRoot(v);
        Tuple b = new Tuple(v, w);
        while (this.path[n - 1] != base) {
            int u = this.even[this.path[n - 1]];
            this.path[n++] = u;
            this.bridges.put(u, b);
            this.queue.add(u);
            this.path[n++] = this.dsf.getRoot(this.odd[u]);
        }
        return Arrays.copyOf(this.path, n);
    }

    private void augment(int v) {
        int n = this.buildPath(this.path, 0, v, -1);
        for (int i = 2; i < n; i += 2) {
            this.matching.match(this.path[i], this.path[i - 1]);
        }
    }

    private int buildPath(int[] path, int i, int start, int goal) {
        while (true) {
            if (this.odd[start] != -1) {
                Tuple bridge = this.bridges.get(start);
                int j = this.buildPath(path, i, bridge.first, start);
                EdmondsMaximumMatching.reverse(path, i, j - 1);
                i = j;
                start = bridge.second;
                continue;
            }
            path[i++] = start;
            if (this.matching.unmatched(start)) {
                return i;
            }
            path[i++] = this.matching.other(start);
            if (path[i - 1] == goal) {
                return i;
            }
            start = this.odd[path[i - 1]];
        }
    }

    private static void reverse(int[] path, int i, int j) {
        while (i < j) {
            int tmp = path[i];
            path[i] = path[j];
            path[j] = tmp;
            ++i;
            --j;
        }
    }

    static Matching maxamise(Matching matching, int[][] graph, BitSet subset) {
        new EdmondsMaximumMatching(graph, matching, subset);
        return matching;
    }

    private static final class Tuple {
        private final int first;
        private final int second;

        private Tuple(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            return 31 * this.first + this.second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple that = (Tuple)o;
            return this.first == that.first && this.second == that.second;
        }
    }
}

