% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-fldcovar.R, R/op-cdo-fldcovar.R
\name{fldcovar}
\alias{fldcovar}
\alias{cdo_fldcovar}
\title{Covariance in grid space}
\usage{
cdo_fldcovar(ifile1, ifile2, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This operator calculates the covariance of two fields over all gridpoints for each timestep. With  S(t) = \{x, i_1(t,x) != missval and i_2(t,x) != missval\}  it is  o(t,1) = Covar\{(i_1(t,x), i_2(t,x)), x_1 < x <= x_n\}  where w(x) are the area weights obtained by the input streams. For every timestep t only those field elements x belong to the sample, which have i_1(t,x) != missval and i_2(t,x) != missval.
}
