% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aic.R
\name{AIC,rateReg-method}
\alias{AIC,rateReg-method}
\title{Akaike Information Criterion (AIC)}
\usage{
\S4method{AIC}{rateReg}(object, ..., k = 2)
}
\arguments{
\item{object}{An object used to dispatch a method.}

\item{...}{Optionally more fitted model objects.}

\item{k}{An optional numeric value used as the penalty per parameter.  The
default \code{k = 2} is the classic AIC.}
}
\value{
If just one object is provided, a numeric value representing
    calculated AIC.  If multiple objects are provided, a data frame with
    rows corresponding to the objects and columns \code{df} and \code{AIC},
    where \code{df} means degree of freedom, which is the number of
    parameters in the fitted model.
}
\description{
\code{AIC,rateReg-method} is an S4 class method calculating Akaike
information criterion (AIC) for one or several \code{rateReg} objects,
according to the formula - 2 * log-likelihood + 2 * nPar, where nPar
represents the number of parameters in the fitted model.
}
\details{
When comparing models fitted by maximum likelihood to the same data, the
smaller the AIC, the better the fit. A friendly warning will be thrown out
if the numbers of observation were different in the model comparison.
\code{help(AIC, stats)} for other details.
}
\examples{
## See examples given in function rateReg.

}
\seealso{
\code{\link{rateReg}} for model fitting;
\code{\link{summary,rateReg-method}} for summary of a fitted model;
\code{\link{BIC,rateReg-method}} for BIC.
}
