% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartOptionsFont.R
\name{chartOptionsFont}
\alias{chartOptionsFont}
\alias{chartOptionsFont,Chart-method}
\title{Modifies the font settings for a \code{\link{Chart-class}}}
\usage{
chartOptionsFont(
  chart,
  titleFont = NULL,
  titleStyle = NULL,
  titleSize = NULL,
  panelFont = NULL,
  panelStyle = NULL,
  panelSize = NULL,
  axisFont = NULL,
  axisStyle = NULL,
  axisSize = NULL,
  legendFont = NULL,
  legendStyle = NULL,
  legendSize = NULL
)

\S4method{chartOptionsFont}{Chart}(
  chart,
  titleFont = NULL,
  titleStyle = NULL,
  titleSize = NULL,
  panelFont = NULL,
  panelStyle = NULL,
  panelSize = NULL,
  axisFont = NULL,
  axisStyle = NULL,
  axisSize = NULL,
  legendFont = NULL,
  legendStyle = NULL,
  legendSize = NULL
)
}
\arguments{
\item{chart}{\code{\link{Chart-class}} object}

\item{titleFont}{character. Sets the font for the title of the
chart axes (e.g., "Microsoft Sans Serif, "Times New Roman", "Arial Narrow").
Default is \code{NULL}.}

\item{titleStyle}{character. Sets the font style for the title. Values can be
"standard", "italic", "bold", or "bold/italic". Default is \code{NULL}.}

\item{titleSize}{integer. Sets the font size for the title of the
chart axes. Default is \code{NULL}.}

\item{panelFont}{character. Sets the font for the title of the chart
panels (e.g., "Microsoft Sans Serif, "Times New Roman", "Arial"). Default
is \code{NULL}.}

\item{panelStyle}{character. Sets the font style for the chart panels. Values
can be "standard", "italic", "bold", or "bold/italic". Default is \code{NULL}.}

\item{panelSize}{integer. Sets the font size for the chart panels. Default is
\code{NULL}.}

\item{axisFont}{character. Sets the font for the title of the chart
panel axes (e.g., "Microsoft Sans Serif, "Times New Roman", "Arial"). Default
is \code{NULL}.}

\item{axisStyle}{character. Sets the font style for the chart panel axes. Values
can be "standard", "italic", "bold", or "bold/italic". Default is \code{NULL}.}

\item{axisSize}{integer. Sets the font size for the chart panel axes. Default
is \code{NULL}.}

\item{legendFont}{character. Sets the font for the title of the
chart legend (e.g., "Microsoft Sans Serif, "Times New Roman", "Arial"). Default
is \code{NULL}.}

\item{legendStyle}{character. Sets the font style for the chart legend. Values
can be "standard", "italic", "bold", or "bold/italic". Default is \code{NULL}.}

\item{legendSize}{integer. Sets the font size for the chart legend. Default
is \code{NULL}.}
}
\value{
A \code{Chart} object representing a SyncroSim chart or, if no arguments
other than the chart are provided, a data.frame of the current chart font
settings.
}
\description{
Modifies the font style and size of various \code{\link{Chart-class}} components.
}
\examples{
\dontrun{
# Open a chart object
myChart <- chart(myProject, chart = "My Chart")

# Set the font for the chart panels
myChart <- chartOptionsFont(myChart, panelFont = "Microsoft Sans Serif", 
                            panelStyle = "bold/italic", panelSize = 8)

# Return a dataframe of the current font settings
myChart <- chartOptionsFont(myChart)
}

}
