% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_discreteVPC.R
\name{discreteVPCTTE}
\alias{discreteVPCTTE}
\alias{interpol.locf}
\alias{interpol.lin}
\title{VPC for time-to-event models}
\usage{
discreteVPCTTE(
  object,
  ngrid = 200,
  interpolation.method = "step",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{an saemixObject object returned by the \code{\link{saemix}} function.
The object must include simulated data under the empirical design,
using the model and estimated parameters from a fit, produced via the
\code{\link{simulateDiscreteSaemix}} function}

\item{ngrid}{number of grid points on the X-axis to extrapolate the KM-VPC}

\item{interpolation.method}{method to use for the interpolation of the KM for the simulated datasets. Available methods are
"step": the value of the survival function for a given grid point is set to the value of the last time
"lin": a linear approximation is used between two consecutive times (defaults to "step")}

\item{verbose}{whether to print messages (defaults to FALSE)}

\item{\dots}{additional arguments, used to pass graphical options (to be implemented, currently not available)}
}
\description{
This function provides VPC plots for time-to-event data models (work in progress)
}
\details{
add details on TTE VPC, RTTE VPC, etc...
}
\seealso{
\code{\link{SaemixObject}}, \code{\link{saemix}},
\code{\link{saemix.plot.vpc}}, \code{\link{simulateDiscreteSaemix}}

Tutorials on TTE-VPC TODO
}
\author{
Emmanuelle Comets \href{mailto:emmanuelle.comets@inserm.fr}{emmanuelle.comets@inserm.fr}
}
\keyword{plot}
