% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estp.R
\name{estp}
\alias{estp}
\title{Sample Size for Estimation of Single Proportion}
\usage{
estp(prop, prec, alp = 0.05, relative = FALSE)
}
\arguments{
\item{prop}{Anticipated proportion of outcome or characteristic of interest in the population}

\item{prec}{Precision required on either side of the population proportion}

\item{alp}{Level of significance or accepted level of probability of type I error}

\item{relative}{a logical argument indicating relative or absolute precision (\code{FALSE} gives absolute precision)}
}
\value{
a list object with minimum required sample size along with description for reporting
}
\description{
This function may be used in case of a descriptive study design where the researcher
wishes to describe the distribution of one or more categorical outcome variables without looking at their
causal relationship and hypothesis testing.
}
\examples{
estp(prop = 0.8, prec = 0.1, alp = 0.01, relative = FALSE)
}
\references{
Lwanga, S. K., Lemeshow, S., & World Health Organization. (1991). Sample size determination in health studies: a practical manual. World Health Organization.
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
