% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inframe.R
\name{max_rank}
\alias{max_rank}
\title{Calculate Max Rank}
\usage{
max_rank(df, col, col_new)
}
\arguments{
\item{df}{dataframe}

\item{col}{character column name to rank y}

\item{col_new}{character column name for rankings}
}
\description{
like rank() with ties.method = "max", works on tbl objects
}
\details{
this is needed for hochberg p value adjustment. We need to assign higher
rank when multiple sites have same p value
}
\examples{

df <- tibble::tibble(s = c(1, 2, 2, 2, 5, 10)) \%>\%
 dplyr::mutate(
   rank = rank(s, ties.method = "max")
 )

df \%>\%
 simaerep:::max_rank("s", "max_rank")
\donttest{
# Database
con <- DBI::dbConnect(duckdb::duckdb(), dbdir = ":memory:")

dplyr::copy_to(con, df, "df")
simaerep:::max_rank(dplyr::tbl(con, "df"), "s", "max_rank")

DBI::dbDisconnect(con)
}
}
\keyword{internal}
