% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_test_data.R
\name{sim_test_data_portfolio}
\alias{sim_test_data_portfolio}
\title{Simulate Portfolio Test Data}
\usage{
sim_test_data_portfolio(
  df_config,
  df_event_rates = NULL,
  progress = TRUE,
  parallel = TRUE
)
}
\arguments{
\item{df_config}{dataframe as returned by \code{\link{get_portf_config}}}

\item{df_event_rates}{dataframe with event rates. Default: NULL}

\item{progress}{logical, Default: TRUE}

\item{parallel}{logical activate parallel processing, see details, Default: FALSE}
}
\value{
dataframe with the following columns: \describe{
\item{\strong{study_id}}{study identification} \item{\strong{event_per_visit_mean}}{mean
event per visit per study} \item{\strong{site_id}}{site}
\item{\strong{max_visit_sd}}{standard deviation of maximum patient visits per
site} \item{\strong{max_visit_mean}}{mean of maximum patient visits per site}
\item{\strong{patient_id}}{number of patients}
\item{\strong{visit}}{visit number}
\item{\strong{n_event}}{cumulative sum of events}
}
}
\description{
Simulate visit level data from a portfolio configuration.
}
\details{
uses \code{\link{sim_test_data_study}}.
We use the \code{furrr} package to
implement parallel processing as these simulations can take a long time to
run. For this to work we need to specify the plan for how the code should
run, e.g. `plan(multisession, workers = 3)
}
\examples{
\donttest{
df_visit1 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 ratio_out = 0.4, factor_event_rate = 0.6,
                                 study_id = "A")

df_visit2 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 ratio_out = 0.2, factor_event_rate = 0.1,
                                 study_id = "B")


df_visit <- dplyr::bind_rows(df_visit1, df_visit2)

df_config <- get_portf_config(df_visit)

df_config

df_portf <- sim_test_data_portfolio(df_config)

df_portf

}
}
\seealso{
\code{\link{sim_test_data_study}}
\code{\link{get_portf_config}}
\code{\link{sim_test_data_portfolio}}
}
