% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyper_tibble.R
\name{hyper_tibble}
\alias{hyper_tibble}
\alias{hyper_tibble.character}
\alias{hyper_tibble.tidync}
\title{Extract NetCDF data as an expanded table.}
\usage{
hyper_tibble(x, ..., na.rm = TRUE, force = FALSE)

\method{hyper_tibble}{character}(x, ..., na.rm = TRUE, force = FALSE)

\method{hyper_tibble}{tidync}(x, ..., na.rm = TRUE, force = FALSE)
}
\arguments{
\item{x}{NetCDF file, connection object, or \code{tidync} object}

\item{...}{arguments to `hyper_filter``}

\item{na.rm}{if \code{TRUE} these rows are not included in the output when all
variables are \code{NA}}

\item{force}{ignore caveats about large extraction and just do it}
}
\value{
a \code{tbl_df}
}
\description{
Extract the raw array data as an expanded data frame. This can be the entire
variable/s or after dimension-slicing using \code{\link[=hyper_filter]{hyper_filter()}} expressions with
dimension values expanded appropriately for each element in the arrays (one
row per element).
}
\details{
The size of an extraction is checked and if \emph{quite large} there is an a user-controlled
prompt to proceed or cancel. This can be disabled with \code{options(tidync.large.data.check = FALSE)}
\itemize{
\item please see \code{\link[=hyper_array]{hyper_array()}} for more details.
}

The function \code{\link[=hyper_tibble]{hyper_tibble()}} will act on an existing tidync object or a source
string.

By default all variables in the active grid are returned, use \code{select_var} to
limit.
}
\examples{
l3file <- "S20080012008031.L3m_MO_CHL_chlor_a_9km.nc"
f <- system.file("extdata", "oceandata", l3file, package= "tidync")
rnc <- tidync(f)
hyper_filter(rnc)
library(dplyr)
lapply(hyper_array(f, lat = lat > 0, lon = index > 3000), dim)

 ht <- hyper_tibble(rnc) \%>\%
 filter(!is.na(chlor_a))
ht
library(ggplot2)
ggplot(ht \%>\% filter(!is.na(chlor_a)),
aes(x = lon, y = lat, fill = chlor_a)) + geom_tile()
}
\seealso{
\code{\link[=hyper_array]{hyper_array()}} and \code{\link[=hyper_tbl_cube]{hyper_tbl_cube()}}  which are also delay-breaking
functions that cause data to be read
}
