% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyper_transforms.R
\name{hyper_transforms}
\alias{hyper_transforms}
\alias{hyper_transforms.default}
\title{Axis transforms}
\usage{
hyper_transforms(x, all = FALSE, ...)

\method{hyper_transforms}{default}(x, all = FALSE, ...)
}
\arguments{
\item{x}{tidync object}

\item{all}{set to \code{TRUE} to return all transforms, not only active ones}

\item{...}{ignored}
}
\value{
list of axis transforms
}
\description{
Axis 'transforms' are data frames of each dimension in a NetCDF source.
\code{hyper_transforms} returns a list of the active transforms by default,
}
\details{
Each transform is available by name from a list, and each data frame has the
coordinate of the dimension, its index, and a 'selected' variable set by the
filtering expressions in \code{hyper_filter} and used by the read-functions
\code{hyper_array} and \code{hyper_tibble}.

Use \code{hyper_transforms} to interrogate and explore the available dimension
manually, or for development of custom functions.
}
\examples{
l3file <- "S20080012008031.L3m_MO_CHL_chlor_a_9km.nc"
f <- system.file("extdata", "oceandata", l3file, package = "tidync")
ax <- tidync(f) \%>\% hyper_transforms()
names(ax)
lapply(ax, dim)

## this function returns the transforms tidync knows about for this source
str(tidync(f)$transforms)
names(hyper_transforms(tidync(f), all = TRUE))
}
