% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robacf.R
\name{robacf}
\alias{robacf}
\title{Robust autocorrelation or autocovariance function estimation}
\usage{
robacf(x, lag.max = NULL, type = c("correlation", "covariance"),
  plot = TRUE, na.action = na.fail, demean = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector or matrix.}

\item{lag.max}{maximum lag at which to calculate the acf. Default is 10*log10(N/m) where
N is the number of observations and m the number of series. Will be automatically limited
to one less than the number of observations in the series.}

\item{type}{character string giving the type of acf to be computed. Allowed values are "correlation" (the default) or "covariance".
Accepts parcial names.}

\item{plot}{logical. If TRUE (the default) the acf is plotted.}

\item{na.action}{function to be called to handle missing values. na.pass can be used.}

\item{demean}{logical. Should the covariances be about the sample means?}

\item{...}{further arguments to be passed to plot.acf.}
}
\value{
An object of class "robacf", which is a list with the following elements:

\code{lag} A three dimensional array containing the lags at which the acf is estimated.

\code{acf} An array with the same dimensions as lag containing the estimated acf.

\code{type} The type of correlation (same as the type argument).

\code{n.used} The number of observations in the time series.

\code{series} The name of the series x.

\code{snames} The series names for a multivariate time series.

The result is returned invisibly if plot is TRUE.
}
\description{
This function computer and plots(by default) the robust estimates of the autocovariance or the autocorrelation function
based on the Qn.
}
\examples{
data.set <- cbind(fdeaths,mdeaths)
robacf(data.set)
robacf(data.set,type="covariance",lag.max=10)
}
\references{
Cotta, H. and Reisen, V. A. and Bondon, P. and Stummer, W. (2017) Robust Estimation of Covariance and Correlation Functions of a Stationary Multivariate Process. \emph{To appear in 2017 25th European Signal Processing Conference (EUSIPCO 2017).}

Ma, Y. and Genton, M. G. (2000) Highly robust estimation of the autocovariance function. \emph{Journal of Time Series Analysis}, \bold{21}, 663--684.

Ma, Y. and Genton, M. G. (2001) Highly robust estimation of dispersion matrices. \emph{Journal of Multivariate Analysis}, \bold{78}, 11--36.

Rousseeuw, P. J. and Croux, C. (1993) Alternatives to the median absolute deviation. \emph{Journal of the American Statistical Association}, \bold{88}, 1273--1283.
}
\author{
Higor Cotta, Valderio Reisen and Pascal Bondon
}
