% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{extract_pls_importance}
\alias{extract_pls_importance}
\title{Extract PLS Variable Importance}
\usage{
extract_pls_importance(pls_result, ncomp = NULL)
}
\arguments{
\item{pls_result}{Result from fit_pls_multivariate.}

\item{ncomp}{Number of components to use. Default uses optimal.}
}
\value{
Data frame with variable names and importance scores.
}
\description{
Extracts variable importance scores from a fitted PLS model.
}
\examples{
\donttest{
if (requireNamespace("pls", quietly = TRUE)) {
  set.seed(123)
  n <- 50
  p <- 10
  X <- matrix(rnorm(n * p), n, p)
  colnames(X) <- paste0("X", 1:p)
  Y <- X[, 1:3] \%*\% diag(c(1, 0.5, 0.3)) + matrix(rnorm(n * 3, 0, 0.5), n, 3)
  colnames(Y) <- paste0("Y", 1:3)

  result <- fit_pls_multivariate(X, Y, max_components = 5)
  importance <- extract_pls_importance(result)
  print(head(importance))
}
}

}
