% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_long.R
\name{emis_long}
\alias{emis_long}
\title{Estimation with long format}
\usage{
emis_long(x, lkm, ef, tfs, speed, verbose = TRUE, array = FALSE)
}
\arguments{
\item{x}{Vehicles data.frame. x repeats down for each hour}

\item{lkm}{Length of each link in km. lkm repeats down for each hour}

\item{ef}{data.frame. ef repeats down for each hour}

\item{tfs}{temporal factor}

\item{speed}{Speed data.frame (nrow x)}

\item{verbose}{Logical to show more info}

\item{array}{Logical to return EmissionsArray or not}
}
\value{
long data.frame
}
\description{
Emissions estimates
}
\examples{
{
data(net)
net <- net[1:100, ]
data(pc_profile)
x <- age_veh(net$ldv)
pc_week <- temp_fact(net$ldv+net$hdv, pc_profile[[1]])
df <- netspeed(pc_week,
               net$ps,
               net$ffs,
               net$capacity,
               net$lkm,
               alpha = 1)

s  <- do.call("rbind",lapply(1:ncol(df), function(i) {
 as.data.frame(replicate(ncol(x), df[, i]))
}))

ef <- ef_wear(wear = "tyre",
              type = "PC",
              pol = "PM10",
              speed = as.data.frame(s))

e <- emis_long(x = x,
               lkm = net$lkm,
               ef = ef,
               tfs = pc_profile[[1]],
               speed = df)

ae <- emis_long(x = x,
               lkm = net$lkm,
               ef = ef,
               tfs = pc_profile[[1]],
               speed = df,
               array = TRUE)
}
}
\seealso{
Other China: 
\code{\link{ef_china}()},
\code{\link{ef_china_det}()},
\code{\link{ef_china_h}()},
\code{\link{ef_china_hu}()},
\code{\link{ef_china_long}()},
\code{\link{ef_china_s}()},
\code{\link{ef_china_speed}()},
\code{\link{ef_china_te}()},
\code{\link{ef_china_th}()},
\code{\link{emis_china}()}
}
\concept{China}
