% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{cohort_components}
\alias{cohort_components}
\title{Extract cohort components from a model}
\usage{
cohort_components(object, ...)
}
\arguments{
\item{object}{A vital mable object with a single model column.}

\item{...}{Not currently used.}
}
\value{
tsibble object containing the cohort components from the model.
}
\description{
For a mable with a single model column, return the model components
that are indexed by birth year of the cohort.
}
\examples{
norway_mortality |>
  dplyr::filter(Sex == "Male", Age > 50, Year > 1960) |>
  model(apc = APC(Mortality)) |>
  cohort_components()
}
